/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.samsung.knox;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.samsung.knox.KNOXDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class LicenseReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("edm.intent.action.license.status")) {
            String result = intent.getStringExtra("edm.intent.extra.license.status");
            LogUtils.i("KNOX receive", "knoxResult " + result);
            if ("success".equals(result)) {
                Intent serviceIntent = new Intent(context, MDMService.class);
                serviceIntent.setAction("mdmKNOXDeviceManagerStatusChanged");
                context.startService(serviceIntent);
            } else if ("fail".equals(result)) {
                KNOXDeviceManager.getmInstance(context).setSuccess(false);
                try {
                    int errorCode = intent.getIntExtra("edm.intent.extra.license.errorcode", -1);
                    String errorMessage = "";
                    switch (errorCode) {
                        case 301: {
                            errorMessage = "Internal error.";
                            break;
                        }
                        case 401: {
                            errorMessage = "Internal server error.";
                            break;
                        }
                        case 201: {
                            errorMessage = "Invalid license.";
                            break;
                        }
                        case 204: {
                            errorMessage = "Invalid package name.";
                            break;
                        }
                        case 203: {
                            errorMessage = "License terminated.";
                            break;
                        }
                        case 501: {
                            errorMessage = "Network disconnected.";
                            break;
                        }
                        case 502: {
                            errorMessage = "General network error.";
                            break;
                        }
                        case 202: {
                            errorMessage = "No more registration with this license.";
                            break;
                        }
                        case 0: {
                            errorMessage = "Success";
                            break;
                        }
                        case 205: {
                            errorMessage = "Not current date";
                            break;
                        }
                        case 101: {
                            errorMessage = "Null parameter.";
                            break;
                        }
                        case 102: {
                            errorMessage = "Unknown error.";
                            break;
                        }
                        case 601: {
                            errorMessage = "User disagrees License agreement.";
                            break;
                        }
                    }
                    LogUtils.o("KONX ERROR : errorCode : " + errorCode + "  errorMessage: " + errorMessage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

