/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.HashMap;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;
import org.zywx.wbpalmstar.plugin.uexMDM.util.MySSLSocketFactory;

public class HttpClientUtility {
    private static final int TIME_OUT = 20000;
    private static final String keyType = "pkcs12";
    private static boolean mIsCertificate = false;
    private static String mPassWord = null;
    private static String mPath = null;
    private static HashMap<String, KeyStore> KEY_STORE = new HashMap();

    public static HttpClient getNewHttpClient(Context ctx, String url) {
        if (mIsCertificate) {
            HttpClientUtility.addPort(url);
            return HttpClientUtility.getHttpsClient(ctx);
        }
        return HttpClientUtility.getHttpClient(url);
    }

    private static HttpClient getHttpClient(String url) {
        try {
            if (TextUtils.isEmpty((CharSequence)url)) {
                return new DefaultHttpClient();
            }
            if (url.startsWith("https")) {
                HttpClientUtility.addPort(url);
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null, null);
                BasicHttpParams params = new BasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                MySSLSocketFactory sf = new MySSLSocketFactory(trustStore);
                sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                registry.register(new Scheme("https", (SocketFactory)sf, 443));
                ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
                return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            }
            return new DefaultHttpClient();
        }
        catch (Exception e) {
            LogUtils.oe("getHttpClient", e);
            return new DefaultHttpClient();
        }
    }

    private static HttpClient getHttpsClient(Context ctx) {
        InputStream inStream = null;
        try {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
            int index = mPath.lastIndexOf(47);
            String keyName = mPath.substring(index);
            KeyStore ksP12 = KEY_STORE.get(keyName);
            if (ksP12 == null) {
                String assertFile = "file:///android_asset/";
                String sdcardFile = "file:///sdcard";
                if (mPath.startsWith(assertFile)) {
                    mPath = mPath.substring(assertFile.length());
                    AssetManager asset = ctx.getAssets();
                    inStream = asset.open(mPath);
                } else if (mPath.startsWith(sdcardFile)) {
                    mPath = mPath.substring("file://".length());
                    inStream = new FileInputStream(mPath);
                } else {
                    inStream = new FileInputStream(mPath);
                }
                ksP12 = KeyStore.getInstance(keyType);
                ksP12.load(inStream, mPassWord.toCharArray());
                KEY_STORE.put(keyName, ksP12);
            }
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            MySSLSocketFactory sf = new MySSLSocketFactory(ksP12);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registry.register(new Scheme("https", (SocketFactory)sf, 443));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            return defaultHttpClient;
        }
        catch (Exception e) {
            LogUtils.oe("getHttpsClient", e);
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            return defaultHttpClient;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setCertificate(boolean isCertificate, String cPassWord, String cPath) {
        mIsCertificate = isCertificate;
        mPassWord = cPassWord;
        mPath = cPath;
    }

    private static void addPort(String url) {
        try {
            URL ul = new URL(url);
            int port = ul.getPort();
            if (port <= 0) {
                LogUtils.o("port is illegal: " + port);
                return;
            }
            String protocol = ul.getProtocol();
            protocol.equals("");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

