/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.zywx.wbpalmstar.base.BUtility;

public class LogUtils {
    static boolean isLog = true;
    static boolean isDebugLog = true;
    static boolean isLogOutput = true;

    public static void i(String tag, String msg) {
        if (isLog) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void w(String tag, String msg) {
        if (isLog) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg) {
        if (isLog) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void v(String tag, String msg) {
        if (isLog) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg) {
        if (isDebugLog) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void o(String text) {
        LogUtils.i("mdmlog", text);
        if (!isLogOutput) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)text) && BUtility.sdCardIsWork()) {
            String developPath = String.valueOf(BUtility.getSdCardRootPath()) + "widgetone/log/";
            File dir = new File(developPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = "mdm_log_" + LogUtils.getCurYearAndMonth() + ".txt";
            File log = new File(String.valueOf(developPath) + fileName);
            BufferedWriter bw = null;
            try {
                try {
                    if (!log.exists()) {
                        log.createNewFile();
                    }
                    bw = new BufferedWriter(new FileWriter(log, true));
                    bw.write("\r" + LogUtils.getNowTime() + "\r" + text);
                    bw.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (bw != null) {
                            bw.close();
                            bw = null;
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                        bw = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void oe(String methodName, Exception e) {
        String outputExceptionStr = String.valueOf(methodName) + " Exception: " + e.getClass().getName() + " Details:" + e.getMessage() + " CauseBy: " + e.getCause();
        LogUtils.o(outputExceptionStr);
    }

    public static int outputLogcatInfo(Context context) {
        int status = 1;
        try {
            String outputPath = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/AppCanDebug.log";
            ArrayList<String> localArrayList = new ArrayList<String>();
            localArrayList.add("logcat");
            localArrayList.add("-d");
            localArrayList.add("-f");
            localArrayList.add(outputPath);
            Process localProcess = Runtime.getRuntime().exec(localArrayList.toArray(new String[localArrayList.size()]));
            status = localProcess.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static String getNowTime() {
        Time time = new Time();
        time.setToNow();
        int year = time.year;
        int month = time.month + 1;
        int day = time.monthDay;
        int minute = time.minute;
        int hour = time.hour;
        int sec = time.second;
        return String.valueOf(year) + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + sec;
    }

    public static String getCurYearAndMonth() {
        Time time = new Time();
        time.setToNow();
        int year = time.year;
        int month = time.month + 1;
        return String.valueOf(year) + "_" + month;
    }
}

