/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.util.http;

import android.annotation.SuppressLint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.AuthenticationParameters;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.IOUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.SSLContextFactory;

public class HttpExApi {
    private SSLContext sslContext;
    private int lastResponseCode;
    private static final String SERVLET_POST = "POST";
    private static final String SERVLET_GET = "GET";
    private static final String SERVLET_DELETE = "DELETE";
    private static final String SERVLET_PUT = "PUT";

    public int getLastResponseCode() {
        return this.lastResponseCode;
    }

    @SuppressLint(value={"NewApi"})
    public HttpExApi(AuthenticationParameters authParams) throws Exception {
        File clientCertFile = authParams.getClientCertificate();
        try {
            this.sslContext = SSLContextFactory.getInstance().makeContext(clientCertFile, authParams.getClientCertificatePassword(), authParams.getCaCertificate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CookieHandler.setDefault(new CookieManager());
    }

    @SuppressLint(value={"NewApi"})
    public HttpExApi(AuthenticationParameters authParams, boolean isBase64) throws Exception {
        String clientCertFileString = authParams.getClientCertificateString();
        try {
            this.sslContext = SSLContextFactory.getInstance().makeContextEx(clientCertFileString, authParams.getClientCertificatePassword(), authParams.getCaCertificate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CookieHandler.setDefault(new CookieManager());
    }

    public String doGet(String url) throws Exception {
        String result = null;
        HttpURLConnection urlConnection = null;
        try {
            try {
                URL requestedUrl = new URL(url);
                urlConnection = (HttpURLConnection)requestedUrl.openConnection();
                if (this.sslContext != null && urlConnection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslContext.getSocketFactory());
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    });
                }
                urlConnection.setRequestMethod(SERVLET_GET);
                urlConnection.setConnectTimeout(1500);
                urlConnection.setReadTimeout(1500);
                this.lastResponseCode = urlConnection.getResponseCode();
                result = IOUtil.readFully(urlConnection.getInputStream());
            }
            catch (Exception ex) {
                result = ex.toString();
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }

    public void doGetFile(String url, File file, String appid, String appverify) {
        if (file == null || !file.exists()) {
            return;
        }
        HttpURLConnection urlConnection = null;
        try {
            try {
                URL requestedUrl = new URL(url);
                urlConnection = (HttpURLConnection)requestedUrl.openConnection();
                if (this.sslContext != null && urlConnection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslContext.getSocketFactory());
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    });
                }
                urlConnection.addRequestProperty("Accept", "*/*");
                urlConnection.setRequestMethod(SERVLET_GET);
                urlConnection.setConnectTimeout(5000);
                urlConnection.connect();
                this.lastResponseCode = urlConnection.getResponseCode();
                InputStream inputStream = urlConnection.getInputStream();
                FileOutputStream outputSteam = new FileOutputStream(file);
                try {
                    try {
                        byte[] buffer = new byte[1024];
                        int available = 0;
                        while ((available = inputStream.read(buffer)) >= 0) {
                            outputSteam.write(buffer, 0, available);
                        }
                        outputSteam.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputSteam != null) {
                            outputSteam.close();
                        }
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputSteam != null) {
                        outputSteam.close();
                    }
                }
            }
            catch (Exception ex) {
                LogUtils.o("doGetFile Exception: " + ex.getMessage());
                ex.printStackTrace();
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public void doPut(String urlStr, Map<String, Object> paramMap) throws Exception {
        HttpURLConnection urlConnection = null;
        URL requestedUrl = new URL(urlStr);
        urlConnection = (HttpURLConnection)requestedUrl.openConnection();
        if (this.sslContext != null && urlConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslContext.getSocketFactory());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        urlConnection.setRequestMethod(SERVLET_PUT);
        Random random = new Random();
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Content-Type", "application/json");
        urlConnection.setRequestProperty("Accept", "application/json");
        OutputStreamWriter osw = new OutputStreamWriter(urlConnection.getOutputStream());
        osw.write(String.format("{\"pos\":{\"left\":%1$d,\"top\":%2$d}}", random.nextInt(30), random.nextInt(20)));
        osw.flush();
        osw.close();
        this.lastResponseCode = urlConnection.getResponseCode();
        System.err.println(urlConnection.getResponseCode());
    }

    public String doPutEx(String urlStr, String xmlStr, String appverify, String appid) throws Exception {
        HttpURLConnection urlConnection = null;
        URL requestedUrl = new URL(urlStr);
        urlConnection = (HttpURLConnection)requestedUrl.openConnection();
        if (this.sslContext != null && urlConnection instanceof HttpsURLConnection) {
            SSLSocketFactory sslSocketFactory = this.sslContext.getSocketFactory();
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        urlConnection.setConnectTimeout(20000);
        urlConnection.setRequestMethod(SERVLET_PUT);
        urlConnection.setRequestProperty("Content-Type", "application/xml");
        urlConnection.setRequestProperty("Accept", "application/xml");
        urlConnection.setRequestProperty("appverify", appverify);
        urlConnection.setRequestProperty("x-mas-app-id", appid);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        OutputStreamWriter osw = new OutputStreamWriter(urlConnection.getOutputStream());
        osw.write(xmlStr);
        osw.flush();
        osw.close();
        urlConnection.connect();
        InputStream is = urlConnection.getInputStream();
        this.lastResponseCode = urlConnection.getResponseCode();
        String result1 = null;
        try {
            result1 = IOUtil.readFully(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result1;
    }

    public String doPostNameValuePairs(String urlStr, String paramsStr, String appverify, String appid) throws Exception {
        HttpURLConnection urlConnection = null;
        URL requestedUrl = new URL(urlStr);
        urlConnection = (HttpURLConnection)requestedUrl.openConnection();
        if (this.sslContext != null && urlConnection instanceof HttpsURLConnection) {
            SSLSocketFactory sslSocketFactory = this.sslContext.getSocketFactory();
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        urlConnection.setRequestMethod(SERVLET_POST);
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConnection.setRequestProperty("Accept", "*/*");
        urlConnection.setRequestProperty("appverify", appverify);
        urlConnection.setRequestProperty("x-mas-app-id", appid);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        OutputStreamWriter osw = new OutputStreamWriter(urlConnection.getOutputStream());
        osw.write(paramsStr);
        osw.flush();
        osw.close();
        InputStream is = urlConnection.getInputStream();
        this.lastResponseCode = urlConnection.getResponseCode();
        String result = null;
        try {
            result = IOUtil.readFully(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String doPostExWithFileStream(String urlStr, File file) throws Exception {
        HttpURLConnection urlConnection = null;
        URL requestedUrl = new URL(urlStr);
        urlConnection = (HttpURLConnection)requestedUrl.openConnection();
        if (this.sslContext != null && urlConnection instanceof HttpsURLConnection) {
            SSLSocketFactory sslSocketFactory = this.sslContext.getSocketFactory();
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostName, SSLSession sslSession) {
                    return true;
                }
            });
        }
        urlConnection.setRequestMethod(SERVLET_POST);
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Content-Type", "application/octet-stream; charset=utf-8");
        urlConnection.setRequestProperty("Accept", "*/*");
        FileInputStream in = new FileInputStream(file);
        OutputStream os = urlConnection.getOutputStream();
        int len = -1;
        byte[] buffer = new byte[4096];
        while ((len = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
            os.write(buffer, 0, len);
        }
        os.flush();
        this.lastResponseCode = urlConnection.getResponseCode();
        String result = null;
        try {
            result = IOUtil.readFully(urlConnection.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((InputStream)in).close();
        os.close();
        return result;
    }

    public static String prepareParam(Map<String, Object> paramMap) {
        StringBuffer sb = new StringBuffer();
        if (paramMap.isEmpty()) {
            return "";
        }
        for (String key : paramMap.keySet()) {
            String value = (String)paramMap.get(key);
            if (sb.length() < 1) {
                sb.append(key).append("=").append(value);
                continue;
            }
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }
}

