/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.util.http;

import android.util.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.zywx.wbpalmstar.plugin.uexMDM.util.InputStreamUtils;
import org.zywx.wbpalmstar.plugin.uexMDM.util.http.CustomTrustManager;

public class SSLContextFactory {
    private static SSLContextFactory theInstance = null;

    private SSLContextFactory() {
    }

    public static SSLContextFactory getInstance() {
        if (theInstance == null) {
            theInstance = new SSLContextFactory();
        }
        return theInstance;
    }

    public SSLContext makeContext(File clientCertFile, String clientCertPassword, String caCertString) throws Exception {
        KeyStore keyStore = this.loadPKCS12KeyStore(clientCertFile, clientCertPassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("X509");
        kmf.init(keyStore, clientCertPassword.toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        KeyStore trustStore = this.loadPEMTrustStore(caCertString);
        TrustManager[] trustManagers = new TrustManager[]{new CustomTrustManager(trustStore)};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public SSLContext makeContextEx(String clientCertString, String clientCertPassword, String caCertString) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream sslInputStream = new ByteArrayInputStream(Base64.decode((byte[])clientCertString.getBytes(), (int)0));
        keyStore.load(sslInputStream, clientCertPassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("X509");
        kmf.init(keyStore, clientCertPassword.toCharArray());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        KeyStore trustStore = null;
        X509TrustManager tm = null;
        if (caCertString != null) {
            trustStore = this.loadPEMTrustStore(caCertString);
            tm = new CustomTrustManager(trustStore);
        } else {
            tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, new TrustManager[]{tm}, null);
        return sslContext;
    }

    private KeyStore loadPEMTrustStore(String certificateString) throws Exception {
        byte[] der = this.loadPemCertificate(new ByteArrayInputStream(certificateString.getBytes()));
        ByteArrayInputStream derInputStream = new ByteArrayInputStream(der);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(derInputStream);
        String alias = cert.getSubjectX500Principal().getName();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        trustStore.setCertificateEntry(alias, cert);
        return trustStore;
    }

    private KeyStore loadPKCS12KeyStore(File certificateFile, String clientCertPassword) throws Exception {
        KeyStore keyStore = null;
        FileInputStream fis = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            fis = new FileInputStream(certificateFile);
            keyStore.load(fis, clientCertPassword.toCharArray());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return keyStore;
    }

    private KeyStore loadPKCS12KeyStoreEx(String certificateString, String clientCertPassword) throws Exception {
        KeyStore keyStore = null;
        InputStream fis = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            fis = InputStreamUtils.StringTOInputStream(certificateString);
            keyStore.load(fis, clientCertPassword.toCharArray());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return keyStore;
    }

    byte[] loadPemCertificate(InputStream certificateStream) throws IOException {
        byte[] der = null;
        BufferedReader br = null;
        try {
            StringBuilder buf = new StringBuilder();
            br = new BufferedReader(new InputStreamReader(certificateStream));
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("--")) {
                    buf.append(line);
                }
                line = br.readLine();
            }
            String pem = buf.toString();
            der = Base64.decode((String)pem, (int)0);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return der;
    }
}

