/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import java.io.Serializable;
import org.zywx.wbpalmstar.engine.EBrowserView;
import org.zywx.wbpalmstar.engine.universalex.EUExBase;
import org.zywx.wbpalmstar.plugin.uexMDM.CallbackHandler;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMLocationService;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMServiceActivity;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class EUExMDM
extends EUExBase {
    public static final String TAG = "uexMDM";
    public static final String MDM_VERSION = "3.0.34";
    public static final String MDM_BUILD_VERSION = "20161213";
    public static final String function_cbLogin = "uexMDM.cbLogin";
    public static final String function_cbOnCrossChanged = "uexMDM.cbOnCrossChanged";
    public static final String function_cbBackupContacts = "uexMDM.cbBackupContacts";
    public static final String function_cbRestoreContacts = "uexMDM.cbRestoreContacts";
    public static final String function_cbRestrictMEM = "uexMDM.cbRestrictMEM";
    public static final String function_cbCheckIsNeedVerifyCode = "uexMDM.cbCheckIsNeedVerifyCode";
    public static final String function_cbGetDeviceIdentifier = "uexMDM.cbGetDeviceIdentifier";
    public static final String function_cbEventFence = "uexMDM.cbEventFence";
    public static final String function_cbSetHost = "uexMDM.cbSetHost";
    public static final String function_cbGetHost = "uexMDM.cbGetHost";
    private CallbackHandler callback;
    private Handler mHandler;

    public EUExMDM(Context context, EBrowserView inParent) {
        super(context, inParent);
    }

    protected boolean clean() {
        Log.i((String)TAG, (String)"clean version : 3.0.34 build : 20161213");
        return true;
    }

    public void destroy() {
        Log.i((String)TAG, (String)"destroy");
        if (this.callback != null) {
            this.callback.clean();
        }
        super.destroy();
    }

    @SuppressLint(value={"HandlerLeak"})
    private void initCallbackBroadCast() {
        if (this.mHandler != null) {
            if (this.callback == null || this.callback.isClean()) {
                this.callback = new CallbackHandler(this.mContext, this.mHandler);
            }
            return;
        }
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 0) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbOnCrossChanged, msg.arg1, 0, (String)msg.obj);
                } else if (msg.what == 1) {
                    LogUtils.i("MDM", "login");
                    EUExMDM.this.jsCallback(EUExMDM.function_cbLogin, 0, 0, "");
                } else if (msg.what == 2) {
                    EUExMDM.this.exitApp((String)msg.obj);
                } else if (msg.what == 3) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbBackupContacts, 0, 2, (String)msg.obj);
                } else if (msg.what == 4) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbRestoreContacts, 0, 2, (String)msg.obj);
                } else if (msg.what == 5) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbRestrictMEM, 0, 2, (String)msg.obj);
                } else if (msg.what == 6) {
                    String isRestrict = (String)msg.obj;
                    if ("1".equals(isRestrict)) {
                        EUExMDM.this.showInputCheckCode();
                    } else if ("0".equals(isRestrict)) {
                        EUExMDM.this.jsCallback(EUExMDM.function_cbCheckIsNeedVerifyCode, 0, 2, isRestrict);
                    } else if ("2".equals(isRestrict)) {
                        EUExMDM.this.jsCallback(EUExMDM.function_cbCheckIsNeedVerifyCode, 0, 2, isRestrict);
                    }
                } else if (msg.what == 7) {
                    String isSuccess = (String)msg.obj;
                    if ("1".equals(isSuccess)) {
                        EUExMDM.this.jsCallback(EUExMDM.function_cbCheckIsNeedVerifyCode, 0, 2, "1");
                    } else {
                        Intent intent = new Intent(EUExMDM.this.mContext, MDMServiceActivity.class);
                        intent.putExtra("action", 6);
                        intent.setFlags(0x30010000);
                        EUExMDM.this.mContext.startActivity(intent);
                    }
                } else if (msg.what == 8) {
                    EUExMDM.this.jsCallback(EUExMDM.function_cbEventFence, msg.arg1, 0, (String)msg.obj);
                } else if (msg.what == 9) {
                    EUExMDM.this.jsCallbackJsonObject(EUExMDM.function_cbSetHost, (String)msg.obj);
                } else if (msg.what == 10) {
                    EUExMDM.this.jsCallbackJsonObject(EUExMDM.function_cbGetHost, (String)msg.obj);
                }
            }
        };
        if (this.callback != null) {
            this.callback.clean();
        }
        this.callback = new CallbackHandler(this.mContext, this.mHandler);
    }

    public void setHost(String[] params) {
        LogUtils.o("setHost");
        this.initCallbackBroadCast();
        Intent in = new Intent();
        in.putExtra("params", params);
        in.putExtra("applicationPid", Process.myPid());
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmInit");
        this.mContext.startService(in);
    }

    public void getHost(String[] params) {
        LogUtils.o("getHost");
        this.initCallbackBroadCast();
        Intent in = new Intent();
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmGetHost");
        this.mContext.startService(in);
    }

    public void login(String[] params) {
        LogUtils.o("login");
        this.initCallbackBroadCast();
        Intent in = new Intent();
        in.putExtra("appKey", this.mBrwView.getCurrentWidget().m_appkey);
        in.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        in.putExtra("applicationPid", Process.myPid());
        in.putExtra("AppLocale", (Serializable)this.mContext.getResources().getConfiguration().locale);
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmLogin");
        this.mContext.startService(in);
    }

    public void getDeviceIdentifier(String[] params) {
        String IMEI = MDMDeviceManager.getInstance(this.mContext).getIMEI();
        this.jsCallback(function_cbGetDeviceIdentifier, 0, 0, IMEI);
    }

    private void showInputCheckCode() {
        LogUtils.o("showInputCheckCode");
        Intent intent = new Intent(this.mContext, MDMServiceActivity.class);
        intent.putExtra("action", 5);
        intent.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        intent.setFlags(0x10010000);
        this.mContext.startActivity(intent);
    }

    public void backupContacts(String[] params) {
        LogUtils.o("backupContacts");
        this.initCallbackBroadCast();
        Intent in = new Intent();
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmBackupContacts");
        this.mContext.startService(in);
    }

    public void restoreContacts(String[] params) {
        LogUtils.o("restoreContacts");
        this.initCallbackBroadCast();
        Intent in = new Intent();
        in.setClass(this.mContext.getApplicationContext(), MDMService.class);
        in.setAction("mdmRestoreContacts");
        this.mContext.startService(in);
    }

    public void reportLocation(String[] params) {
        LogUtils.o("reportLocation");
        Intent serviceIntent = new Intent("mdmGetLocation");
        serviceIntent.putExtra("mdmLocationType", 1);
        serviceIntent.setClass(this.mContext, MDMLocationService.class);
        this.mContext.startService(serviceIntent);
    }

    public void reportNetworkTraffic(String[] params) {
        LogUtils.o("reportNetworkTraffic");
        Intent serviceIntent = new Intent("mdmReportNetworkTraffic");
        serviceIntent.setClass(this.mContext, MDMService.class);
        this.mContext.startService(serviceIntent);
    }

    public void exitApp(String[] params) {
        LogUtils.o("exitApp");
        String message = null;
        if (params.length > 0) {
            message = params[0];
        }
        this.exitApp(message);
    }

    public void restrictMEM(String[] params) {
        LogUtils.o("restrictMEM");
        this.initCallbackBroadCast();
        Intent serviceIntent = new Intent("mdmIsRestrictMEM");
        serviceIntent.setClass(this.mContext, MDMService.class);
        serviceIntent.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        this.mContext.startService(serviceIntent);
    }

    public void checkIsNeedVerifyCode(String[] params) {
        LogUtils.o("checkIsNeedVerifyCode");
        this.initCallbackBroadCast();
        Intent serviceIntent = new Intent("mdmCheckIsNeedVerifyCode");
        serviceIntent.setClass(this.mContext, MDMService.class);
        serviceIntent.putExtra("appId", this.mBrwView.getCurrentWidget().m_appId);
        this.mContext.startService(serviceIntent);
    }

    public void eventFence(String[] params) {
        LogUtils.o("eventFence");
        if (params == null || params.length < 3) {
            return;
        }
        this.initCallbackBroadCast();
        Intent serviceIntent = new Intent("mdmEventTirgger");
        serviceIntent.setClass(this.mContext, MDMService.class);
        serviceIntent.putExtra("opId", params[0]);
        serviceIntent.putExtra("eventName", params[1]);
        serviceIntent.putExtra("type", params[2]);
        this.mContext.startService(serviceIntent);
    }

    private void exitApp(String message) {
        Intent intent = new Intent(this.mContext, MDMServiceActivity.class);
        intent.putExtra("message", message);
        intent.putExtra("action", 4);
        intent.setFlags(0x10018000);
        this.mContext.startActivity(intent);
    }

    private void jsCallbackJsonObject(String jsCallbackName, String jsonData) {
        String js = "javascript:if(" + jsCallbackName + "){" + jsCallbackName + "(" + jsonData + ");}";
        this.onCallback(js);
    }
}

