/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.annotation.SuppressLint;
import android.app.KeyguardManager;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.AdminReceiver;
import org.zywx.wbpalmstar.plugin.uexMDM.BatteryReceiver;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMBlueToothManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMServiceActivity;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMWifiManager;
import org.zywx.wbpalmstar.plugin.uexMDM.PkgSizeObserver;
import org.zywx.wbpalmstar.plugin.uexMDM.data.DeviceInfo;
import org.zywx.wbpalmstar.plugin.uexMDM.data.MDMPasswordConfigInfo;
import org.zywx.wbpalmstar.plugin.uexMDM.samsung.knox.KNOXDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

@SuppressLint(value={"NewApi"})
public class MDMDeviceManager {
    private static String TAG = "MDMDeviceManager";
    private static MDMDeviceManager mInstance;
    private Context mContext;
    private DeviceInfo deviceInfo;
    private DevicePolicyManager mDPManager;
    private KNOXDeviceManager mKNOXDPManager;
    private ComponentName componentName;
    private static BatteryReceiver receiverBattery;
    public static final int F_DEVICE_INFO_ID_ORIENTATION_PORTRAIT = 1;
    public static final int F_DEVICE_INFO_ID_ORIENTATION_LANDSCAPE = 2;
    public static final int F_JV_CONNECT_UNREACHABLE = -1;
    public static final int F_JV_CONNECT_WIFI = 0;
    public static final int F_JV_CONNECT_3G = 1;
    public static final int F_JV_CONNECT_GPRS = 2;

    private MDMDeviceManager(Context ctx) {
        LogUtils.i(TAG, "MDMDeviceManager constructor");
        this.mContext = ctx;
        EUExUtil.init((Context)ctx);
        this.mDPManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        this.componentName = new ComponentName(this.mContext, AdminReceiver.class);
        this.deviceInfo = new DeviceInfo(ctx, this);
        this.mKNOXDPManager = KNOXDeviceManager.getmInstance(ctx);
    }

    public void clear() {
        Log.d((String)"receiverBattery", (String)"receiverbattery be clear");
        if (receiverBattery != null) {
            this.mContext.getApplicationContext().unregisterReceiver((BroadcastReceiver)receiverBattery);
            receiverBattery = null;
        }
    }

    private static void RegisterBatteryReceiver(Context ctx) {
        receiverBattery = new BatteryReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        ctx.getApplicationContext().registerReceiver((BroadcastReceiver)receiverBattery, filter);
    }

    public static synchronized MDMDeviceManager getInstance(Context ctx) {
        if (mInstance == null) {
            mInstance = new MDMDeviceManager(ctx);
        }
        if (receiverBattery == null) {
            MDMDeviceManager.RegisterBatteryReceiver(ctx);
        }
        return mInstance;
    }

    public synchronized KNOXDeviceManager getKNOXManager() {
        return this.mKNOXDPManager;
    }

    public DeviceInfo getDeviceInfo() {
        this.deviceInfo.updateData();
        return this.deviceInfo;
    }

    public String getAndroidID() {
        String androidId = "undefined";
        try {
            androidId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        }
        catch (Exception e) {
            LogUtils.oe("getAndroidID", e);
            e.printStackTrace();
        }
        return androidId;
    }

    public String getKeyBoardType() {
        String type = null;
        switch (this.mContext.getResources().getConfiguration().keyboard) {
            case 3: {
                type = "1";
                break;
            }
            case 2: {
                type = "1";
                break;
            }
            case 1: {
                type = "0";
                break;
            }
            case 0: {
                type = "0";
            }
        }
        return type;
    }

    public File outputLogcatInfo(Context context) {
        int status = 1;
        File file = null;
        try {
            String outputPath = String.valueOf(context.getDir("files", 0).getAbsolutePath()) + "/AppCanDebug.log";
            ArrayList<String> localArrayList = new ArrayList<String>();
            localArrayList.add("logcat");
            localArrayList.add("-d");
            localArrayList.add("-f");
            localArrayList.add(outputPath);
            Process localProcess = Runtime.getRuntime().exec(localArrayList.toArray(new String[localArrayList.size()]));
            status = localProcess.waitFor();
            LogUtils.o("outputLogcatInfo: status==" + status);
            file = new File(outputPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public String getCPUFrequency() {
        String result;
        block16: {
            result = "";
            BufferedReader isr = null;
            try {
                try {
                    Process pp = Runtime.getRuntime().exec("cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq");
                    isr = new LineNumberReader(new InputStreamReader(pp.getInputStream()));
                    String line = ((LineNumberReader)isr).readLine();
                    if (line != null && line.length() > 0) {
                        try {
                            result = String.valueOf(Integer.parseInt(line.trim()) / 1000) + "MHZ";
                        }
                        catch (Exception e) {
                            LogUtils.oe("getCPUFrequency", e);
                        }
                        break block16;
                    }
                    result = "0";
                }
                catch (IOException ex) {
                    LogUtils.oe("getCPUFrequency", ex);
                    ex.printStackTrace();
                    try {
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public String getBlueToothSupport() {
        String supported = "0";
        try {
            Class<?> btClass;
            Method method;
            if (Build.VERSION.SDK_INT >= 5 && (method = (btClass = Class.forName("android.bluetooth.BluetoothAdapter")).getMethod("getDefaultAdapter", new Class[0])).invoke(btClass, new Object[0]) != null) {
                supported = "1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return supported;
    }

    public String getWIFISupport() {
        String supported = "0";
        if ((WifiManager)this.mContext.getSystemService("wifi") != null) {
            supported = "1";
        }
        return supported;
    }

    public String getCameraSupport() {
        String support = "0";
        try {
            Camera camera = Camera.open();
            if (camera != null) {
                support = "1";
                camera.release();
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"no_permisson_declare"), (int)0).show();
        }
        return support;
    }

    public String getGPSSupport() {
        String support = "0";
        try {
            LocationManager locationManager = (LocationManager)this.mContext.getSystemService("location");
            if (locationManager != null) {
                support = "1";
            }
        }
        catch (SecurityException e) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"no_permisson_declare"), (int)0).show();
        }
        return support;
    }

    public String getMobileDataNetworkSupport() {
        String support = "0";
        try {
            NetworkInfo info;
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getApplicationContext().getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null && info.getType() == 0) {
                support = "1";
            }
        }
        catch (SecurityException e) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"no_permisson_declare"), (int)0).show();
        }
        return support;
    }

    public boolean setCameraEnable(boolean isCameraEnabled) {
        try {
            if (this.mKNOXDPManager.isKNOXactive()) {
                this.mKNOXDPManager.setCameraEnable(isCameraEnabled);
            } else {
                this.mDPManager.setCameraDisabled(this.componentName, !isCameraEnabled);
            }
        }
        catch (Exception e) {
            LogUtils.oe("setCameraEnable", e);
            e.printStackTrace();
        }
        return isCameraEnabled;
    }

    public void setWifiEnable(boolean isWifiEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setWiFiEnable(isWifiEnabled);
        } else {
            MDMWifiManager.getInstance(this.mContext).setWifiAllRestricted(isWifiEnabled);
        }
    }

    public void setMobileDataEnabled(boolean isEnabled) {
        try {
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getApplicationContext().getSystemService("connectivity");
            if (cm != null) {
                Method setMobileDataEnabledMethod = cm.getClass().getMethod("setMobileDataEnabled", Boolean.TYPE);
                if (setMobileDataEnabledMethod != null) {
                    setMobileDataEnabledMethod.invoke((Object)cm, isEnabled);
                    LogUtils.o("setMobileDataEnabled: " + isEnabled);
                }
            } else {
                LogUtils.o("setMobileDataEnabled: ConnectivityManager is null");
            }
        }
        catch (SecurityException e) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"no_permisson_declare"), (int)0).show();
            LogUtils.oe("setMobileDataEnabled", e);
        }
        catch (Exception e) {
            LogUtils.oe("setMobileDataEnabled", e);
        }
    }

    public int getNetworkStatus() {
        int status = -1;
        try {
            NetworkInfo info;
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getApplicationContext().getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null && info.isAvailable()) {
                block1 : switch (info.getType()) {
                    case 0: {
                        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
                        switch (telephonyManager.getNetworkType()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: {
                                status = 2;
                                break block1;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: {
                                status = 1;
                            }
                        }
                        break;
                    }
                    case 1: {
                        status = 0;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (SecurityException e) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"no_permisson_declare"), (int)0).show();
        }
        return status;
    }

    public String getMobileOperatorName() {
        String name = "unKnown";
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (telephonyManager.getSimState() == 5) {
            String imsi = telephonyManager.getNetworkOperator();
            LogUtils.i(TAG, "imsiNum: " + imsi);
            name = imsi.equals("46000") || imsi.equals("46002") ? "\u4e2d\u56fd\u79fb\u52a8" : (imsi.equals("46001") ? "\u4e2d\u56fd\u8054\u901a" : (imsi.equals("46003") ? "\u4e2d\u56fd\u7535\u4fe1" : telephonyManager.getSimOperatorName()));
        }
        return name;
    }

    public String getPhoneNumber() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String phoneNumber = telephonyManager.getLine1Number();
        if (phoneNumber == null) {
            phoneNumber = "unKnown";
        }
        return phoneNumber;
    }

    public String getTouchScreenType() {
        String type = "0";
        switch (this.mContext.getResources().getConfiguration().touchscreen) {
            case 3: {
                type = "1";
                break;
            }
            case 2: {
                type = "1";
                break;
            }
            case 1: {
                type = "0";
            }
        }
        return type;
    }

    public boolean clearPassCode() {
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            this.mDPManager.setPasswordQuality(this.componentName, 0);
            this.mDPManager.setPasswordMinimumLength(this.componentName, 0);
            this.mDPManager.setPasswordMinimumSymbols(this.componentName, 0);
            return this.resetPassword("");
        }
        return false;
    }

    public void requirePasscode() {
    }

    public boolean resetPassword(String password) {
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            return this.mDPManager.resetPassword(password, 0);
        }
        return false;
    }

    public boolean wipeData() {
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            this.mDPManager.wipeData(4);
            return true;
        }
        return false;
    }

    public boolean isDeviceManagerActive() {
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        return active;
    }

    public void openDeviceManager() {
        Log.d((String)"device", (String)"----openDeviceManager----");
        Intent intent = new Intent();
        intent.setClass(this.mContext, MDMServiceActivity.class);
        intent.putExtra("action", 0);
        intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)this.componentName);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    public void closeDeviceManager() {
        Log.d((String)"device", (String)"----closeDeviceManager----");
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            this.mDPManager.removeActiveAdmin(this.componentName);
        }
    }

    public boolean lockScreen() {
        Log.d((String)"device", (String)"----lockScreen----");
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            try {
                this.lockNow();
            }
            catch (Exception e) {
                LogUtils.oe("lockScreen", e);
            }
            return true;
        }
        return false;
    }

    private void lockNow() {
        KeyguardManager km = (KeyguardManager)this.mContext.getSystemService("keyguard");
        KeyguardManager.KeyguardLock kl = km.newKeyguardLock(this.mContext.getPackageName());
        if (Build.VERSION.SDK_INT >= 14) {
            if (kl != null) {
                kl.disableKeyguard();
            }
            this.mDPManager.lockNow();
            if (kl != null) {
                kl.reenableKeyguard();
            }
        } else {
            this.mDPManager.lockNow();
        }
    }

    public void install(File apkFile, String commandUUID) {
        LogUtils.o("install app start: " + (apkFile == null ? "null" : apkFile.getAbsolutePath()));
        if (this.mKNOXDPManager.isKNOXactive()) {
            boolean result = this.mKNOXDPManager.installApplication(apkFile.getAbsolutePath(), false);
            if (result) {
                MDMService.mapOfCommandAck.get(commandUUID).setInstallApplication(true);
                Intent in = new Intent("mdmAckcommand");
                in.putExtra("commandUUID", commandUUID);
                in.setClass(this.mContext, MDMService.class);
                this.mContext.startService(in);
            }
        } else {
            Intent intent = new Intent();
            intent.setClass(this.mContext, MDMServiceActivity.class);
            intent.putExtra("action", 1);
            intent.putExtra("commandUUID", commandUUID);
            intent.setFlags(0x10000000);
            intent.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
            this.mContext.startActivity(intent);
        }
    }

    public void uninstall(String packageName, String commandUUID) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            boolean result = this.mKNOXDPManager.uninstallApplication(packageName, false);
            MDMService.mapOfCommandAck.get(commandUUID).setUnInstallApplication(result);
            Intent in = new Intent("mdmAckcommand");
            in.putExtra("commandUUID", commandUUID);
            in.setClass(this.mContext, MDMService.class);
            this.mContext.startService(in);
        } else {
            Intent intent = new Intent();
            intent.setClass(this.mContext, MDMServiceActivity.class);
            intent.putExtra("action", 2);
            intent.putExtra("commandUUID", commandUUID);
            intent.setData(Uri.parse((String)("package:" + packageName)));
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }

    public List<PackageInfoData> getAllInstallApplication() {
        PackageManager pkgMgr = this.mContext.getPackageManager();
        List packs = pkgMgr.getInstalledPackages(0);
        ArrayList<PackageInfoData> infodata = new ArrayList<PackageInfoData>();
        for (PackageInfo pack : packs) {
            infodata.add(new PackageInfoData(pack));
        }
        return infodata;
    }

    public List<PackageInfoData> getUserInstallApplication() {
        List<PackageInfoData> packs = this.getAllInstallApplication();
        ArrayList<PackageInfoData> userPacks = new ArrayList<PackageInfoData>();
        int count = packs.size();
        int i = 0;
        while (i < count) {
            PackageInfo p = packs.get((int)i).packageInfo;
            ApplicationInfo appInfo = p.applicationInfo;
            if ((appInfo.flags & 1) <= 0) {
                userPacks.add(packs.get(i));
            }
            ++i;
        }
        return userPacks;
    }

    public List<PackageInfoData> getSystemInstallApplication() {
        List<PackageInfoData> packs = this.getAllInstallApplication();
        ArrayList<PackageInfoData> sysPacks = new ArrayList<PackageInfoData>();
        int count = packs.size();
        int i = 0;
        while (i < count) {
            PackageInfo p = packs.get((int)i).packageInfo;
            ApplicationInfo appInfo = p.applicationInfo;
            if ((appInfo.flags & 1) > 0) {
                sysPacks.add(packs.get(i));
            }
            ++i;
        }
        return sysPacks;
    }

    public void setDateRoaming(boolean enabled) {
    }

    public void setVoiceRoaming(boolean enabled) {
    }

    private boolean getMobileDataStatus(Context context) {
        ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
        Class<?> conMgrClass = null;
        Field iConMgrField = null;
        Object iConMgr = null;
        Class<?> iConMgrClass = null;
        Method getMobileDataEnabledMethod = null;
        try {
            conMgrClass = Class.forName(conMgr.getClass().getName());
            iConMgrField = conMgrClass.getDeclaredField("mService");
            iConMgrField.setAccessible(true);
            iConMgr = iConMgrField.get(conMgr);
            iConMgrClass = Class.forName(iConMgr.getClass().getName());
            getMobileDataEnabledMethod = iConMgrClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            getMobileDataEnabledMethod.setAccessible(true);
            return (Boolean)getMobileDataEnabledMethod.invoke(iConMgr, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void toggleMobileData(Context context, boolean enabled) {
        ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
        Class<?> conMgrClass = null;
        Field iConMgrField = null;
        Object iConMgr = null;
        Class<?> iConMgrClass = null;
        Method setMobileDataEnabledMethod = null;
        try {
            conMgrClass = Class.forName(conMgr.getClass().getName());
            iConMgrField = conMgrClass.getDeclaredField("mService");
            iConMgrField.setAccessible(true);
            iConMgr = iConMgrField.get(conMgr);
            iConMgrClass = Class.forName(iConMgr.getClass().getName());
            setMobileDataEnabledMethod = iConMgrClass.getDeclaredMethod("setMobileDataEnabled", Boolean.TYPE);
            setMobileDataEnabledMethod.setAccessible(true);
            setMobileDataEnabledMethod.invoke(iConMgr, enabled);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String getSoftToken() {
        String appKey = EUExUtil.getString((String)"appkey");
        SharedPreferences preferences = this.mContext.getSharedPreferences("app", 0);
        String softToken = preferences.getString("softToken", null);
        if (softToken != null) {
            return softToken;
        }
        String[] val = new String[4];
        try {
            val[0] = this.getMacAddress();
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = MDMDeviceManager.getCPUSerial();
            val[3] = MDMDeviceManager.decodeStr(appKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtils.o("mac : " + val[0] + " deviceId : " + val[1] + " cpu : " + val[2] + " app : " + val[3]);
        softToken = MDMDeviceManager.getMD5Code(val);
        if (softToken == null || appKey == null) {
            return null;
        }
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("softToken", softToken);
        editor.commit();
        return softToken;
    }

    public String getDeviceToken() {
        SharedPreferences preferences = this.mContext.getSharedPreferences("app", 0);
        String deviceToken = preferences.getString("deviceToken", null);
        if (deviceToken != null) {
            return deviceToken;
        }
        String[] val = new String[3];
        try {
            val[0] = this.getMacAddress();
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = MDMDeviceManager.getCPUSerial();
        }
        catch (Exception telephonyManager) {
            // empty catch block
        }
        deviceToken = MDMDeviceManager.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("deviceToken", deviceToken);
        editor.commit();
        return deviceToken;
    }

    public String getDeviceUUID() {
        SharedPreferences preferences = this.mContext.getSharedPreferences("app", 0);
        String deviceUUID = preferences.getString("deviceUUID", null);
        if (deviceUUID != null) {
            return deviceUUID;
        }
        deviceUUID = this.readUUIDFromFile();
        if (deviceUUID != null) {
            return deviceUUID;
        }
        try {
            String deviceId;
            String androidId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            deviceUUID = androidId != null && !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")).toString() : ((deviceId = ((TelephonyManager)this.mContext.getSystemService("phone")).getDeviceId()) != null ? UUID.nameUUIDFromBytes(deviceId.getBytes("utf8")).toString() : UUID.randomUUID().toString());
        }
        catch (Exception e) {
            deviceUUID = UUID.randomUUID().toString();
        }
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("deviceUUID", deviceUUID);
        editor.commit();
        this.saveUUIDToFile(deviceUUID);
        return deviceUUID;
    }

    private String readUUIDFromFile() {
        try {
            File deviceUUIDFile;
            if ("mounted".equals(Environment.getExternalStorageState()) && (deviceUUIDFile = new File(Environment.getExternalStorageDirectory(), ".system.mdm")).exists()) {
                RandomAccessFile f = new RandomAccessFile(deviceUUIDFile, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                f.close();
                return new String(bytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void saveUUIDToFile(String uuid) {
        try {
            if ("mounted".equals(Environment.getExternalStorageState())) {
                File deviceUUIDFile = new File(Environment.getExternalStorageDirectory(), ".system.mdm");
                FileOutputStream out = new FileOutputStream(deviceUUIDFile);
                out.write(uuid.getBytes());
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIMEI() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String imei = telephonyManager.getDeviceId();
        return imei;
    }

    public String getICCID() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String iccid = telephonyManager.getSimSerialNumber();
        if (iccid == null) {
            iccid = "unknown";
        }
        return iccid;
    }

    public String getIMSI() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String imsi = telephonyManager.getSubscriberId();
        if (imsi == null) {
            imsi = "unknown";
        }
        return imsi;
    }

    private static String getCPUSerial() {
        String str = "";
        String strCPU = "";
        String cpuAddress = "0000000000000000";
        try {
            Process pp = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str != null) {
                    if (str.indexOf("Serial") <= -1) continue;
                    strCPU = str.substring(str.indexOf(":") + 1, str.length());
                    cpuAddress = strCPU.trim();
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return cpuAddress;
    }

    public static String getMD5Code(String[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String va = stringArray[n2];
                if (va == null) {
                    va = "";
                }
                md.update(va.getBytes());
                ++n2;
            }
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            int i = 0;
            while (i < md5Bytes.length) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
                ++i;
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeStr(String key) {
        char[] map = new char[]{'d', 'b', 'e', 'a', 'f', 'c'};
        char[] nmap = new char[]{'2', '4', '0', '9', '7', '1', '5', '8', '3', '6'};
        String dest = "";
        String swapstr = "";
        String output = "";
        int j = 0;
        while (j < key.length()) {
            if (key.charAt(j) != '-') {
                swapstr = String.valueOf(swapstr) + key.charAt(j);
            }
            ++j;
        }
        j = 0;
        while (j < swapstr.length()) {
            if (j == 8 || j == 12 || j == 16 || j == 20) {
                dest = String.valueOf(dest) + "-";
            }
            dest = String.valueOf(dest) + swapstr.charAt(swapstr.length() - j - 1);
            ++j;
        }
        int i = 0;
        while (i < dest.length()) {
            char t = dest.charAt(i);
            if (t >= 'a' && t <= 'f') {
                t = map[t - 97];
            } else if (t >= '0' && t <= '9') {
                t = nmap[t - 48];
            }
            output = String.valueOf(output) + t;
            ++i;
        }
        return output;
    }

    public String getMacAddress() {
        String macSerial = null;
        if (Build.VERSION.SDK_INT > 22) {
            macSerial = MDMDeviceManager.readFileContent("/sys/class/net/wlan0/address").trim();
        }
        if (!TextUtils.isEmpty(macSerial)) {
            return macSerial;
        }
        try {
            WifiManager wifi = (WifiManager)this.mContext.getApplicationContext().getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            macSerial = info.getMacAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (macSerial == null) {
            macSerial = this.getMac();
        }
        return macSerial;
    }

    private static String readFileContent(String path) {
        String content = "";
        try {
            if (new File(path).exists()) {
                FileInputStream fis = new FileInputStream(path);
                byte[] buffer = new byte[8192];
                int byteCount = fis.read(buffer);
                if (byteCount > 0) {
                    content = new String(buffer, 0, byteCount, "utf-8");
                }
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    private String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    public boolean removePasswordConfig() {
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            this.mDPManager.setPasswordQuality(this.componentName, 0);
            this.mDPManager.setPasswordMinimumLength(this.componentName, 0);
            this.mDPManager.setPasswordMinimumSymbols(this.componentName, 0);
            this.mDPManager.setMaximumTimeToLock(this.componentName, 0L);
            this.mDPManager.setPasswordExpirationTimeout(this.componentName, 0L);
            this.mDPManager.setPasswordMinimumSymbols(this.componentName, 0);
            this.mDPManager.setPasswordHistoryLength(this.componentName, 0);
            this.mDPManager.setMaximumFailedPasswordsForWipe(this.componentName, Integer.MAX_VALUE);
            return true;
        }
        return false;
    }

    public void setPasswordConfig(MDMPasswordConfigInfo pci, String commandUUID) {
        boolean active = this.mDPManager.isAdminActive(this.componentName);
        if (active) {
            if (pci.minComplexChars > 0) {
                this.mDPManager.setPasswordQuality(this.componentName, 393216);
            } else if (pci.isRequiredAlphanumeric == 1) {
                this.mDPManager.setPasswordQuality(this.componentName, 327680);
            } else {
                this.mDPManager.setPasswordQuality(this.componentName, 0);
            }
            if (pci.maxInactivity >= 0) {
                this.mDPManager.setMaximumTimeToLock(this.componentName, (long)(pci.maxInactivity * 60 * 1000));
            }
            if (pci.minlength >= 0) {
                this.mDPManager.setPasswordMinimumLength(this.componentName, pci.minlength);
            }
            if (pci.minComplexChars >= 0) {
                this.mDPManager.setPasswordMinimumSymbols(this.componentName, pci.minComplexChars);
            }
            if (pci.maxPinAgeIndays >= 0) {
                this.mDPManager.setPasswordExpirationTimeout(this.componentName, (long)(pci.maxPinAgeIndays * 86400 * 1000));
            }
            if (pci.pinHistory >= 0) {
                this.mDPManager.setPasswordHistoryLength(this.componentName, pci.pinHistory);
            }
            if (pci.maxFailedAttempts >= 1) {
                this.mDPManager.setMaximumFailedPasswordsForWipe(this.componentName, pci.maxFailedAttempts);
            } else {
                this.mDPManager.setMaximumFailedPasswordsForWipe(this.componentName, Integer.MAX_VALUE);
            }
            Intent intent = new Intent();
            intent.setClass(this.mContext, MDMServiceActivity.class);
            intent.putExtra("action", 3);
            intent.putExtra("commandUUID", commandUUID);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }

    public synchronized boolean checkRootStatus() {
        boolean isRoot = this.getRootStatus();
        LogUtils.o("isRoot?==" + isRoot);
        return isRoot;
    }

    public synchronized boolean getRootStatus() {
        boolean isRoot;
        block16: {
            Log.i((String)"mdmLogin", (String)"getRootStatus");
            Process process = null;
            FilterOutputStream os = null;
            isRoot = false;
            try {
                try {
                    process = Runtime.getRuntime().exec("su");
                    os = new DataOutputStream(process.getOutputStream());
                    ((DataOutputStream)os).writeBytes("exit\n");
                    ((DataOutputStream)os).flush();
                    int exitValue = process.waitFor();
                    if (exitValue == 0) {
                        isRoot = true;
                        break block16;
                    }
                    isRoot = true;
                }
                catch (Exception e) {
                    Log.w((String)"*** DEBUG ***", (String)("Unexpected error - Here is what I know: " + e.getMessage()));
                    LogUtils.o("cannot run su command " + e.getMessage());
                    isRoot = false;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        if (process != null) {
                            process.destroy();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return isRoot;
    }

    public static boolean isRooted() {
        String buildTags = Build.TAGS;
        if (buildTags != null && buildTags.contains("test-keys")) {
            return true;
        }
        try {
            File file = new File("/system/app/Superuser.apk");
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MDMDeviceManager.canExecuteCommand("/system/xbin/which su") || MDMDeviceManager.canExecuteCommand("/system/bin/which su") || MDMDeviceManager.canExecuteCommand("which su");
    }

    private static boolean canExecuteCommand(String command) {
        boolean executedSuccesfully;
        try {
            Runtime.getRuntime().exec(command);
            executedSuccesfully = true;
        }
        catch (Exception e) {
            executedSuccesfully = false;
        }
        return executedSuccesfully;
    }

    public boolean canRunRootCommands() {
        boolean retval = false;
        try {
            Process suProcess = Runtime.getRuntime().exec("su");
            DataOutputStream os = new DataOutputStream(suProcess.getOutputStream());
            DataInputStream osRes = new DataInputStream(suProcess.getInputStream());
            if (os != null && osRes != null) {
                os.writeBytes("id\n");
                os.flush();
                String currUid = osRes.readLine();
                boolean exitSu = false;
                if (currUid == null) {
                    retval = false;
                    exitSu = false;
                    Log.d((String)"ROOT", (String)"Can't get root access or denied by user");
                } else if (currUid.contains("uid=0")) {
                    retval = true;
                    exitSu = true;
                    Log.d((String)"ROOT", (String)"Root access granted");
                } else {
                    retval = false;
                    exitSu = true;
                    Log.d((String)"ROOT", (String)("Root access rejected: " + currUid));
                }
                if (exitSu) {
                    os.writeBytes("exit\n");
                    os.flush();
                }
            }
        }
        catch (Exception e) {
            retval = false;
            Log.d((String)"ROOT", (String)("Root access rejected [" + e.getClass().getName() + "] : " + e.getMessage()));
        }
        return retval;
    }

    public void setScreenCaptureEnable(boolean isScreenCaptureEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setScreenCaptureEnable(isScreenCaptureEnable);
        }
    }

    public void setClipboardEnabled(boolean isClipboardEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setClipboardEnabled(isClipboardEnable);
        }
    }

    public void setBluetoothEnable(boolean isBluetoothEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setBluetoothEnable(isBluetoothEnabled);
        }
        MDMBlueToothManager.getInstance(this.mContext).setBluetoothAllRestricted(isBluetoothEnabled);
        if (!isBluetoothEnabled) {
            MDMBlueToothManager.getInstance(this.mContext).closeBlueTooth();
        }
    }

    public void setAndroidBeamEnable(boolean isAndroidBeamEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setAndroidBeamEnable(isAndroidBeamEnable);
        }
    }

    public void setHeadphoneEnable(boolean isHeadphoneEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setHeadphoneEnable(isHeadphoneEnabled);
        }
    }

    public void setMicrophoneEnable(boolean isMicrophoneEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setMicrophoneEnable(isMicrophoneEnabled);
        }
    }

    public void setAudioRecordEnable(boolean isAudioRecordEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setAudioRecordEnable(isAudioRecordEnable);
        }
    }

    public void setVideoRecordEnable(boolean isVideoRecordEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setVideoRecordEnable(isVideoRecordEnable);
        }
    }

    public void setNFCEnable(boolean isNFCEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setNFCEnable(isNFCEnable);
        }
    }

    public void setMockLocationEnable(boolean isMockLocationEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setMockLocationEnable(isMockLocationEnable);
        }
    }

    public void setHomeKeyEnable(boolean isHomeKeyEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setHomeKeyEnable(isHomeKeyEnable);
        }
    }

    public void setDeveloperModeEnable(boolean isDeveloperModeEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setDeveloperModeEnable(isDeveloperModeEnable);
        }
    }

    public void setUsbDebuggingEnabled(boolean isUsbDebuggingEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setUsbDebuggingEnabled(isUsbDebuggingEnable);
        }
    }

    public void setUsbMediaPlayerAvailabilityEnable(boolean isUsbMediaPlayerAvailabilityEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setUsbMediaPlayerAvailabilityEnable(isUsbMediaPlayerAvailabilityEnable);
        }
    }

    public void setUsbTethering(boolean isUsbTetheringEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setUsbTethering(isUsbTetheringEnable);
        }
    }

    public void setUsbHostStorageEnable(boolean isUsbHostStorageEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setUsbHostStorageEnable(isUsbHostStorageEnable);
        }
    }

    public void setSDCardWriteEnable(boolean isSDCardWriteEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setSDCardWriteEnable(isSDCardWriteEnable);
        }
    }

    public void setSdCardEnable(boolean isSDCardEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setSdCardEnable(isSDCardEnable);
        }
    }

    public void setCallPhoneEnable(boolean enable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setEmergencyCallOnly(!enable);
        }
    }

    public void setAllMessageEnable(boolean isAllMessageEnable) {
        this.setIncomingSMSEnable(isAllMessageEnable);
        this.setOutgoingSMSEnable(isAllMessageEnable);
        this.setIncomingMMSEnable(isAllMessageEnable);
        this.setOutgoingMMSEnable(isAllMessageEnable);
    }

    public void setIncomingSMSEnable(boolean isIncomingSMSEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setIncomingSMSEnable(isIncomingSMSEnabled);
        }
    }

    public void setOutgoingSMSEnable(boolean isOutgoingSMSEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setOutgoingSMSEnable(isOutgoingSMSEnabled);
        }
    }

    public void setIncomingMMSEnable(boolean isIncomingMMSEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setIncomingMMSEnable(isIncomingMMSEnabled);
        }
    }

    public void setOutgoingMMSEnable(boolean isOutgoingMMSEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setOutgoingMMSEnable(isOutgoingMMSEnabled);
        }
    }

    public void changeApplicationIcon(String packageName, byte[] imageData) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.changeApplicationIcon(packageName, imageData);
        }
    }

    public void setApplicationUninstallationDisabled(String packageName) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setApplicationUninstallationDisabled(packageName);
        }
    }

    public void setApplicationUninstallationEnabled(String packageName) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setApplicationUninstallationEnabled(packageName);
        }
    }

    public void setApplicationInstallationDisabled(String packageName) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setApplicationInstallationDisabled(packageName);
        }
    }

    public void setApplicationInstallationEnabled(String packageName) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setApplicationInstallationEnabled(packageName);
        }
    }

    public void setAppInsAndUninsEnable(boolean isAppInsAndUninsEnable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setAppInstallEnable(isAppInsAndUninsEnable);
            this.mKNOXDPManager.setAppUninstallEnable(isAppInsAndUninsEnable);
        }
    }

    public void setPositionEnable(boolean isPositionEnable) {
        this.setGPSStateChangeEnabled(true);
        List<String> providers = this.getAllLocationProviders();
        if (providers != null) {
            int i = 0;
            while (i < providers.size()) {
                this.setLocationProviderState(providers.get(i), isPositionEnable);
                ++i;
            }
        }
        this.setGPSStateChangeEnabled(isPositionEnable);
    }

    public void startGPS(boolean start) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.startGPS(start);
        }
    }

    public void setGPSStateChangeEnabled(boolean isGPSStateChangeEnabled) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setGPSStateChangeEnabled(isGPSStateChangeEnabled);
        }
    }

    public List<String> getAllLocationProviders() {
        List<String> result = null;
        if (this.mKNOXDPManager.isKNOXactive()) {
            result = this.mKNOXDPManager.getAllLocationProviders();
        }
        return result;
    }

    public void setLocationProviderState(String provider, boolean enable) {
        if (this.mKNOXDPManager.isKNOXactive()) {
            this.mKNOXDPManager.setLocationProviderState(provider, enable);
        }
    }

    public class PackageInfoData {
        public PackageInfo packageInfo;
        public long totalsize = 0L;
        public long staticsize = 0L;
        public boolean isSizeInvoke = false;
        public String packName = "unidentified";
        public String applicationName = "unidentified";
        public String shortVersion = "unidentified";
        public String version = "unidentified";
        public boolean isSystem = true;
        public PkgSizeObserver sizeObserver;

        public PackageInfoData(PackageInfo pack) {
            this.packageInfo = pack;
            this.packName = pack.packageName;
            this.applicationName = pack.applicationInfo.loadLabel(MDMDeviceManager.this.mContext.getPackageManager()).toString();
            this.shortVersion = String.valueOf(pack.versionCode);
            this.version = pack.versionName;
            this.sizeObserver = new PkgSizeObserver(this);
            ApplicationInfo appInfo = pack.applicationInfo;
            this.isSystem = (appInfo.flags & 1) > 0;
            this.updateSize();
        }

        public void updateSize() {
            this.isSizeInvoke = false;
            PackageManager pm = MDMDeviceManager.this.mContext.getPackageManager();
            try {
                Method getPackageSizeInfo = pm.getClass().getMethod("getPackageSizeInfo", String.class, IPackageStatsObserver.class);
                getPackageSizeInfo.invoke((Object)pm, this.packName, this.sizeObserver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

