/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.TrafficStats;
import android.os.SystemClock;
import android.text.format.Time;
import android.util.Log;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMNetworkTrafficStatsMgr {
    private static MDMNetworkTrafficStatsMgr sNetworkTrafficStatsMgr;
    private static final String SP_NAME_NET_TRAFFIC_STATS = "plugin_mdm_NetworkTrafficStats";
    private static final String SP_KEY_NOT_CUR_MONTH_TOTAL_BYTES = "last_month_total";
    private static final String SP_KEY_CUR_MONTH_TOTAL_BYTES = "cur_month_total";
    private static final String SP_KEY_BOOT_TIME = "boot_time";
    private static final String SP_KEY_RECORD_TIME = "record_time";
    private static final String SP_KEY_LAST_REPORT_TIME = "last_report_time";
    private static final String SP_KEY_BEFORE_BOOT_BYTES = "before_boot_bytes";
    private SharedPreferences mLocalData;
    private SharedPreferences.Editor mLocalDataEditor;

    private MDMNetworkTrafficStatsMgr() {
    }

    private MDMNetworkTrafficStatsMgr(Context context) {
        this.mLocalData = context.getSharedPreferences(SP_NAME_NET_TRAFFIC_STATS, 0);
        this.mLocalDataEditor = this.mLocalData.edit();
    }

    public static MDMNetworkTrafficStatsMgr getInstance(Context context) {
        if (sNetworkTrafficStatsMgr == null) {
            sNetworkTrafficStatsMgr = new MDMNetworkTrafficStatsMgr(context);
        }
        return sNetworkTrafficStatsMgr;
    }

    public void calculateStatsLocalData() {
        long localBootTime = this.mLocalData.getLong(SP_KEY_BOOT_TIME, -1L);
        long actualBootTime = this.getSystemBootTime();
        LogUtils.o("localBootTime: " + localBootTime + " actualBootTime: " + actualBootTime);
        if (this.isBootedOnCurMonth()) {
            if (localBootTime != -1L && Math.abs(actualBootTime - localBootTime) < 1000L) {
                long beforeBootsBytes = this.mLocalData.getLong(SP_KEY_BEFORE_BOOT_BYTES, 0L);
                long curTotalBytes = beforeBootsBytes + this.getElapsedTimeNetworkTrafficStats();
                this.mLocalDataEditor.putLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, curTotalBytes).commit();
            } else {
                long localCurTotalBytes = this.mLocalData.getLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, 0L);
                this.mLocalDataEditor.putLong(SP_KEY_BEFORE_BOOT_BYTES, localCurTotalBytes).commit();
                long curTotalBytes = localCurTotalBytes + this.getElapsedTimeNetworkTrafficStats();
                this.mLocalDataEditor.putLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, curTotalBytes).commit();
                this.mLocalDataEditor.putLong(SP_KEY_BOOT_TIME, actualBootTime).commit();
            }
        } else {
            long localRecordTime = this.mLocalData.getLong(SP_KEY_RECORD_TIME, -1L);
            if (localBootTime != -1L) {
                if (localRecordTime < this.getCurMonthStartTimeMillis()) {
                    long localCurTotalBytes = this.mLocalData.getLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, 0L);
                    long localBeforeBootBytes = this.mLocalData.getLong(SP_KEY_BEFORE_BOOT_BYTES, 0L);
                    long localNotCurMonthTotalBytes = localCurTotalBytes - localBeforeBootBytes;
                    this.mLocalDataEditor.putLong(SP_KEY_NOT_CUR_MONTH_TOTAL_BYTES, localNotCurMonthTotalBytes).commit();
                    long curMonthBytes = this.getElapsedTimeNetworkTrafficStats() - localNotCurMonthTotalBytes;
                    this.mLocalDataEditor.putLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, curMonthBytes).commit();
                } else {
                    long localNotCurMonthTotalBytes = this.mLocalData.getLong(SP_KEY_NOT_CUR_MONTH_TOTAL_BYTES, 0L);
                    long curMonthBytes = this.getElapsedTimeNetworkTrafficStats() - localNotCurMonthTotalBytes;
                    this.mLocalDataEditor.putLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, curMonthBytes).commit();
                }
            } else {
                this.mLocalDataEditor.putLong(SP_KEY_NOT_CUR_MONTH_TOTAL_BYTES, this.getElapsedTimeNetworkTrafficStats()).commit();
                this.mLocalDataEditor.putLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, 0L).commit();
                this.mLocalDataEditor.putLong(SP_KEY_BOOT_TIME, actualBootTime).commit();
            }
        }
        this.mLocalDataEditor.putLong(SP_KEY_RECORD_TIME, System.currentTimeMillis()).commit();
    }

    public long getCurMonthNetworkTrafficStats() {
        long curMonthNetworkTrafficBytes = this.mLocalData.getLong(SP_KEY_CUR_MONTH_TOTAL_BYTES, 0L);
        Log.i((String)"MDMTraffic", (String)("traffic bytes: " + curMonthNetworkTrafficBytes));
        return curMonthNetworkTrafficBytes;
    }

    private long getElapsedTimeNetworkTrafficStats() {
        long receivedBytes = TrafficStats.getMobileRxBytes();
        long transmittedBytes = TrafficStats.getMobileTxBytes();
        long totalBytes = receivedBytes + transmittedBytes;
        return totalBytes;
    }

    public void updateReportTime() {
        this.mLocalDataEditor.putLong(SP_KEY_LAST_REPORT_TIME, System.currentTimeMillis()).commit();
    }

    public long getLastReportTime() {
        long lastReportTime = this.mLocalData.getLong(SP_KEY_LAST_REPORT_TIME, -1L);
        return lastReportTime;
    }

    private long getSystemBootTime() {
        long systemBootTime = System.currentTimeMillis() - SystemClock.elapsedRealtime();
        return systemBootTime;
    }

    private long getCurMonthStartTimeMillis() {
        Time time = new Time();
        time.setToNow();
        time.set(0, 0, 0, 1, time.month, time.year);
        time.isDst = 0;
        return time.toMillis(false);
    }

    private boolean isBootedOnCurMonth() {
        return this.getSystemBootTime() > this.getCurMonthStartTimeMillis();
    }
}

