/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexMDM.AdminReceiver;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMService;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMServiceActivity
extends Activity {
    public static final int F_START_DEVICE_MANAGER_REQUEST = 0;
    public static final int F_INSTALL_APPLICATION = 1;
    public static final int F_UNINSTALL_APPLICATION = 2;
    public static final int F_START_SETPASSWORD_REQUEST = 3;
    public static final int F_ALERT_EXIT_APP = 4;
    public static final int F_ALERT_INPUTCHECKCODE = 5;
    public static final int F_ALERT_INPUTCHECKCODE_ERROR = 6;
    public static final int F_EXIT_APP = 7;
    public static final String EXTRA_KEY_ACTION = "action";
    public static final String EXTRA_KEY_MESSAGE = "message";
    public static final String EXTRA_KEY_APPID = "appId";
    private static boolean isDeviceManagerActive = true;
    private String commandUUID;
    private String uninstallPackage;
    private BootReceiver mUninstallReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Intent in = this.getIntent();
            this.commandUUID = in.getStringExtra("commandUUID");
            int action = in.getIntExtra(EXTRA_KEY_ACTION, -1);
            final String appId = in.getStringExtra(EXTRA_KEY_APPID);
            Intent intent = new Intent();
            this.mUninstallReceiver = new BootReceiver();
            switch (action) {
                case 0: {
                    isDeviceManagerActive = MDMDeviceManager.getInstance((Context)this).isDeviceManagerActive();
                    ComponentName componentName = (ComponentName)in.getParcelableExtra("android.app.extra.DEVICE_ADMIN");
                    intent.setAction("android.app.action.ADD_DEVICE_ADMIN");
                    intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)componentName);
                    intent.putExtra("android.app.extra.ADD_EXPLANATION", EUExUtil.getString((String)"plugin_mdm_device_des"));
                    break;
                }
                case 1: {
                    intent.setAction("android.intent.action.VIEW");
                    intent.setDataAndType(in.getData(), in.getType());
                    break;
                }
                case 2: {
                    intent.setAction("android.intent.action.DELETE");
                    this.uninstallPackage = in.getDataString();
                    intent.setData(in.getData());
                    IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_REMOVED");
                    filter.addDataScheme("package");
                    this.registerReceiver((BroadcastReceiver)this.mUninstallReceiver, filter);
                    break;
                }
                case 3: {
                    intent.setAction("android.app.action.SET_NEW_PASSWORD");
                    IntentFilter filter1 = new IntentFilter("android.app.action.ACTION_PASSWORD_CHANGED");
                    this.registerReceiver((BroadcastReceiver)this.mUninstallReceiver, filter1);
                    break;
                }
                case 4: {
                    String hintMessage = in.getStringExtra(EXTRA_KEY_MESSAGE);
                    if (TextUtils.isEmpty((CharSequence)hintMessage)) {
                        hintMessage = EUExUtil.getString((String)"plugin_mdm_exitapp_default_hintmessage");
                    }
                    LogUtils.o("exitApp : " + hintMessage);
                    AlertDialog.Builder tDialog = new AlertDialog.Builder((Context)this);
                    tDialog.setCancelable(false);
                    tDialog.setTitle((CharSequence)EUExUtil.getString((String)"plugin_mdm_exitapp"));
                    tDialog.setMessage((CharSequence)hintMessage);
                    tDialog.setPositiveButton((CharSequence)EUExUtil.getString((String)"exit"), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            Process.killProcess((int)Process.myPid());
                        }
                    });
                    tDialog.show();
                    return;
                }
                case 5: {
                    this.showAlertInputCheckCode(appId);
                    return;
                }
                case 6: {
                    AlertDialog.Builder tErrorDialog = new AlertDialog.Builder((Context)this);
                    tErrorDialog.setCancelable(false);
                    tErrorDialog.setTitle((CharSequence)EUExUtil.getString((String)"plugin_mdm_verifycode_title"));
                    tErrorDialog.setMessage((CharSequence)EUExUtil.getString((String)"plugin_mdm_verifycode_error_message"));
                    tErrorDialog.setPositiveButton((CharSequence)EUExUtil.getString((String)"confirm"), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            MDMServiceActivity.this.showAlertInputCheckCode(appId);
                        }
                    });
                    tErrorDialog.show();
                    return;
                }
                case 7: {
                    this.finish();
                }
                default: {
                    this.finish();
                    return;
                }
            }
            this.startActivityForResult(intent, action);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish();
        }
    }

    private void showAlertInputCheckCode(final String appId) {
        final EditText editText = new EditText((Context)this);
        editText.setTextSize(15.0f);
        AlertDialog.Builder inputCheckCodeDialog = new AlertDialog.Builder((Context)this);
        inputCheckCodeDialog.setCancelable(false);
        inputCheckCodeDialog.setTitle((CharSequence)EUExUtil.getString((String)"plugin_mdm_verifycode"));
        inputCheckCodeDialog.setView((View)editText);
        inputCheckCodeDialog.setPositiveButton((CharSequence)EUExUtil.getString((String)"confirm"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LogUtils.o("Confirm2CheckVerifyCode");
                dialog.dismiss();
                Intent serviceIntent = new Intent("mdmCheckVerifyCode");
                serviceIntent.setClass(MDMServiceActivity.this.getApplicationContext(), MDMService.class);
                serviceIntent.putExtra(MDMServiceActivity.EXTRA_KEY_APPID, appId);
                String checkCode = editText.getText().toString();
                serviceIntent.putExtra("checkCode", checkCode);
                MDMServiceActivity.this.startService(serviceIntent);
                MDMServiceActivity.this.finish();
            }
        });
        inputCheckCodeDialog.setNegativeButton((CharSequence)EUExUtil.getString((String)"exit"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                Intent exitIntent = new Intent((Context)MDMServiceActivity.this, MDMServiceActivity.class);
                exitIntent.putExtra(MDMServiceActivity.EXTRA_KEY_ACTION, 7);
                exitIntent.addFlags(805404672);
                MDMServiceActivity.this.startActivity(exitIntent);
            }
        });
        inputCheckCodeDialog.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0) {
            try {
                if (!isDeviceManagerActive) {
                    isDeviceManagerActive = MDMDeviceManager.getInstance((Context)this).isDeviceManagerActive();
                    Intent serviceIntent = new Intent((Context)this, MDMService.class);
                    serviceIntent.setAction("mdmDeviceManagerStatusChanged");
                    serviceIntent.putExtra("type", isDeviceManagerActive ? 0 : 1);
                    this.startService(serviceIntent);
                }
            }
            catch (Exception e) {
                LogUtils.oe("DeviceManagerRequest", e);
            }
            this.finish();
        } else {
            Log.d((String)"serviceActivity", (String)("onActivityResult,requsetCode=" + requestCode + " ,resultCode=" + resultCode + " commandUUID=" + this.commandUUID));
            if (requestCode == 1) {
                if (resultCode == -1) {
                    MDMService.mapOfCommandAck.get(this.commandUUID).setInstallApplication(true);
                } else {
                    MDMService.mapOfCommandAck.get(this.commandUUID).setInstallApplication(false);
                }
            } else if (requestCode == 2) {
                MDMService.mapOfCommandAck.get(this.commandUUID).setUnInstallApplication(this.mUninstallReceiver.isUnInstall);
                this.unregisterReceiver((BroadcastReceiver)this.mUninstallReceiver);
            } else if (requestCode == 3) {
                MDMService.mapOfCommandAck.get(this.commandUUID).setRequestPassword(this.mUninstallReceiver.isPasswordChange);
                this.unregisterReceiver((BroadcastReceiver)this.mUninstallReceiver);
            }
            Intent in = new Intent("mdmAckcommand");
            in.putExtra("commandUUID", this.commandUUID);
            in.setClass((Context)this, MDMService.class);
            this.startService(in);
            this.finish();
        }
    }

    public class BootReceiver
    extends AdminReceiver {
        public boolean isUnInstall = false;

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PACKAGE_ADDED")) {
                String packageName = intent.getDataString();
                System.out.println("\u5b89\u88c5\u4e86:" + packageName + "\u5305\u540d\u7684\u7a0b\u5e8f");
            } else if (intent.getAction().equals("android.intent.action.PACKAGE_REMOVED")) {
                String packageName = intent.getDataString();
                this.isUnInstall = MDMServiceActivity.this.uninstallPackage != null && MDMServiceActivity.this.uninstallPackage.equals(packageName);
            } else {
                super.onReceive(context, intent);
            }
        }
    }
}

