/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MDMWarningManager
implements MediaPlayer.OnCompletionListener {
    private static final String TAG = "uexMDM_MDMWarningManager";
    private static final String SP_MDM_CONFIG = "mdmConfig";
    private static final String WARNING_FILE_PATH = "MDMFile/WARNING/";
    private static final String WARNING_FOLDER = "WarningRing";
    private static final String WARNING_FILE_NAME = "warning.mp3";
    private static MDMWarningManager sInstance;
    private AudioManager audioManager = null;
    private File warningFile = null;
    private MediaPlayer mediaPlayer = null;
    private SharedPreferences mdmConfigSp;

    private MDMWarningManager(Context context) {
        Log.i((String)TAG, (String)Thread.currentThread().getName());
        this.mdmConfigSp = context.getApplicationContext().getSharedPreferences(SP_MDM_CONFIG, 0);
        this.audioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
        File extCacheDir = context.getExternalFilesDir(Environment.DIRECTORY_ALARMS);
        File chatFolder = null;
        if (extCacheDir != null) {
            try {
                chatFolder = new File(extCacheDir, WARNING_FOLDER);
                if (!chatFolder.exists()) {
                    chatFolder.mkdirs();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.warningFile = new File(chatFolder, WARNING_FILE_NAME);
        this.copyFileToSDCard(context);
    }

    public static MDMWarningManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new MDMWarningManager(context);
        }
        return sInstance;
    }

    public void setVolumeMax(int streamType) {
        int currentVolum;
        int maxVolum = this.audioManager.getStreamMaxVolume(streamType);
        if (maxVolum != (currentVolum = this.audioManager.getStreamVolume(streamType))) {
            this.audioManager.setStreamVolume(streamType, maxVolum, 8);
        }
    }

    public void setRingVolumeMax() {
        int maxVolum = this.audioManager.getStreamMaxVolume(1);
        this.audioManager.setStreamVolume(1, maxVolum, 8);
    }

    public void setWarningMode(int streamType) {
        this.audioManager.setMode(streamType);
    }

    public synchronized void WARNING(Context context) {
        this.copyFileToSDCard(context);
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
        }
        if (this.mediaPlayer.isPlaying()) {
            return;
        }
        this.mediaPlayer.setLooping(true);
        try {
            this.mediaPlayer.setDataSource(this.warningFile.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mediaPlayer.setAudioStreamType(2);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        try {
            this.mediaPlayer.prepare();
            this.mediaPlayer.start();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setWarning(boolean isWarning) {
        return this.mdmConfigSp.edit().putBoolean("isWarning", isWarning).commit();
    }

    public boolean isWarning() {
        return this.mdmConfigSp.getBoolean("isWarning", false);
    }

    public boolean isFileExists() {
        return this.warningFile.exists();
    }

    public boolean copyFileToSDCard(Context context) {
        if (this.warningFile.exists()) {
            return true;
        }
        FileOutputStream output = null;
        InputStream input = null;
        String path = "MDMFile/WARNING/warning.mp3";
        try {
            try {
                int len;
                input = path.startsWith("/") ? new FileInputStream(path) : context.getAssets().open(path);
                output = new FileOutputStream(this.warningFile);
                byte[] b = new byte[5120];
                while ((len = input.read(b)) != -1) {
                    output.write(b, 0, len);
                }
                output.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return false;
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public void onCompletion(MediaPlayer mp) {
    }
}

