/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMWifiManager;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class MDMWifiBroadCastReceiver
extends BroadcastReceiver {
    private static final String TAG = "MDMWifiBroadCastReceiver";

    public void onReceive(Context context, Intent intent) {
        NetworkInfo info;
        if (intent == null) {
            return;
        }
        LogUtils.i(TAG, "Action: " + intent.getAction() + " PackageName: " + context.getPackageName());
        String action = intent.getAction();
        if ("android.net.wifi.STATE_CHANGE".equals(action) && (info = (NetworkInfo)intent.getParcelableExtra("networkInfo")).getType() == 1) {
            if (info.getState().equals((Object)NetworkInfo.State.DISCONNECTED)) {
                LogUtils.o("WIFI disconnected!");
            } else if (info.getState().equals((Object)NetworkInfo.State.CONNECTED)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                LogUtils.o("WIFI connected!");
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                if (wifiInfo != null) {
                    String ssid = wifiInfo.getSSID();
                    LogUtils.o("WIFI connected with " + ssid);
                    if (MDMWifiManager.getInstance(context).isWifiRestricted(ssid)) {
                        wifiManager.disconnect();
                        wifiManager.disableNetwork(wifiInfo.getNetworkId());
                        LogUtils.o("WIFI " + ssid + "is Restricted!");
                    }
                }
            }
        }
    }
}

