/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.data;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Random;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMBlueToothManager;
import org.zywx.wbpalmstar.plugin.uexMDM.MDMDeviceManager;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class DeviceInfo {
    public double AvailableDeviceCapacity;
    public double BatteryLevel;
    public String BuildVersion;
    public double DeviceCapacity;
    public String DeviceName;
    public String IMEI;
    public String ICCID;
    public String IMSI;
    public String Model;
    public String ModelName;
    public String ModemFirmwareVersion;
    public String OSVersion;
    public String SerialNumber;
    public String UDID;
    public String BluetoothMAC;
    public String WiFiMAC;
    public String SubscriberCarrierNetwork;
    public String PhoneNumber;
    private Context mContext;
    private MDMDeviceManager deviceManager;

    private DeviceInfo() {
    }

    public DeviceInfo(Context ctx, MDMDeviceManager deviceManager) {
        LogUtils.i("DeviceInfo", "constructor");
        this.mContext = ctx;
        this.deviceManager = deviceManager;
        this.BuildVersion = this.getBuildVersion();
        this.DeviceCapacity = this.getPhoneCapacity();
        this.AvailableDeviceCapacity = this.getPhoneAvailableCapacity();
        this.DeviceName = this.getDeviceName();
        this.IMEI = this.getDeviceIMEI();
        this.Model = this.getModeNum();
        this.ModelName = this.getModeName();
        this.ModemFirmwareVersion = this.getModemFirmwareVersion();
        this.OSVersion = this.getOsVersion();
        this.SerialNumber = this.getSerialNumber();
        this.UDID = this.getUDID();
        this.BatteryLevel = 0.0;
        this.BluetoothMAC = this.getBlueToothMAC();
        this.WiFiMAC = this.getWiFiMAC();
        this.SubscriberCarrierNetwork = this.getSubscriberCarrierNetwork();
        this.PhoneNumber = this.getPhoneNumber();
        this.ICCID = this.getICCID();
        this.IMSI = this.getIMSI();
    }

    public String getBlueToothMAC() {
        return MDMBlueToothManager.getInstance(this.mContext).getBlueToothMACAddress();
    }

    public String getSubscriberCarrierNetwork() {
        return this.deviceManager.getMobileOperatorName();
    }

    public String getPhoneNumber() {
        return this.deviceManager.getPhoneNumber();
    }

    public String getWiFiMAC() {
        return this.deviceManager.getMacAddress();
    }

    public String getICCID() {
        return this.deviceManager.getICCID();
    }

    public String getIMSI() {
        return this.deviceManager.getIMSI();
    }

    private String getModeName() {
        return Build.MANUFACTURER;
    }

    private String getDeviceName() {
        return Build.DEVICE;
    }

    private String getBuildVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    private String getModeNum() {
        return Build.MODEL;
    }

    private String getOsVersion() {
        return "Android " + Build.VERSION.RELEASE;
    }

    public void updateData() {
        this.AvailableDeviceCapacity = this.getPhoneAvailableCapacity();
    }

    private double getPhoneAvailableCapacity() {
        File data = Environment.getDataDirectory();
        StatFs statFs = new StatFs(data.getPath());
        long availableBlocks = statFs.getAvailableBlocks();
        long size = statFs.getBlockSize();
        long availableSize = availableBlocks * size;
        double availableSizeGB = (double)availableSize * 1.0 / 1024.0 / 1024.0 / 1024.0;
        return availableSizeGB;
    }

    private double getPhoneCapacity() {
        File data = Environment.getDataDirectory();
        StatFs statFs = new StatFs(data.getPath());
        long blockCount = statFs.getBlockCount();
        long size = statFs.getBlockSize();
        long totalSize = blockCount * size;
        double totalSizeGB = (double)totalSize * 1.0 / 1024.0 / 1024.0 / 1024.0;
        return totalSizeGB;
    }

    public String sdcardCapacity() {
        File sdData = Environment.getExternalStorageDirectory();
        StatFs sdStatFs = new StatFs(sdData.getPath());
        long sdAvailableBlocks = sdStatFs.getAvailableBlocks();
        long sdBlockcount = sdStatFs.getBlockCount();
        long sdSize = sdStatFs.getBlockSize();
        long sdTotalSize = sdBlockcount * sdSize;
        long sdAvailableSize = sdAvailableBlocks * sdSize;
        String sdcardCapacity = String.valueOf(Long.toString(sdAvailableSize / 1024L / 1024L)) + "MB/" + Long.toString(sdTotalSize / 1024L / 1024L) + "MB";
        return sdcardCapacity;
    }

    private String getUDID() {
        String DEVICE_ID = null;
        SharedPreferences preferences = this.mContext.getSharedPreferences("app", 1);
        DEVICE_ID = preferences.getString("DEVICE_ID", null);
        if (DEVICE_ID == null || DEVICE_ID.equalsIgnoreCase("9774d56d682e549c")) {
            TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
            DEVICE_ID = tm.getDeviceId();
        }
        if (DEVICE_ID == null) {
            DEVICE_ID = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        }
        if (DEVICE_ID == null || DEVICE_ID.equalsIgnoreCase("9774d56d682e549c")) {
            DEVICE_ID = "" + new Random();
        }
        preferences.edit().putString("DEVICE_ID", DEVICE_ID).commit();
        return DEVICE_ID;
    }

    @SuppressLint(value={"NewApi"})
    private String getSerialNumber() {
        String serialNumber = Build.SERIAL;
        return serialNumber;
    }

    private String getModemFirmwareVersion() {
        String modemVersion = null;
        try {
            Class<?> cl = Class.forName("android.os.SystemProperties");
            Object invoker = cl.newInstance();
            Method m = cl.getMethod("get", String.class, String.class);
            Object result = m.invoke(invoker, "gsm.version.baseband", "no message");
            modemVersion = result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modemVersion;
    }

    private String getDeviceIMEI() {
        String imei = "unknown";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            if (telephonyManager != null && telephonyManager.getDeviceId() != null) {
                imei = telephonyManager.getDeviceId();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return imei;
    }

    private String getSimSerialNumber() {
        String serialNumber = "unknown";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            if (telephonyManager != null && telephonyManager.getSimSerialNumber() != null) {
                serialNumber = telephonyManager.getSimSerialNumber();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return serialNumber;
    }

    private String getRestDiskSize() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return "0";
        }
        String sdPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        StatFs fs = new StatFs(sdPath);
        long unit = fs.getBlockSize();
        long avaliable = fs.getAvailableBlocks();
        long size = unit * avaliable;
        return String.valueOf(size);
    }
}

