/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import java.util.Locale;
import org.zywx.wbpalmstar.plugin.uexMDM.util.LogUtils;

public class LanguageUtils {
    private static final String LANGUAGE_SP_NAME = "AppLanguage";
    private static final String LANGUAGE_SP_KEY = "uexMDM_Language";

    public static String getSystemLanguage() {
        Locale language = Locale.getDefault();
        return String.valueOf(language.getLanguage()) + "-" + language.getCountry();
    }

    public static String getAppLanguage(Context context) {
        Locale language = context.getApplicationContext().getResources().getConfiguration().locale;
        return LanguageUtils.getAppLanguage(language);
    }

    public static String getAppLanguage(Locale locale) {
        return String.valueOf(locale.getLanguage()) + "-" + locale.getCountry();
    }

    public static void changeAppLanguage(Context context, String language) {
        Locale locale = Locale.ENGLISH;
        try {
            String[] languageName = language.split("-");
            locale = languageName.length > 1 ? new Locale(languageName[0], languageName[1]) : new Locale(language);
        }
        catch (Exception e) {
            LogUtils.o("changeAppLanguage Error : language : " + language);
            return;
        }
        LanguageUtils.changeAppLanguage(context, locale);
    }

    public static void changeAppLanguage(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        DisplayMetrics dm = resources.getDisplayMetrics();
        if (config.locale.equals(locale)) {
            return;
        }
        config.locale = locale;
        resources.updateConfiguration(config, dm);
    }

    public static boolean saveCurrentLanguage(Context context, String language) {
        SharedPreferences sp = context.getApplicationContext().getSharedPreferences(LANGUAGE_SP_NAME, 0);
        String langSp = sp.getString(LANGUAGE_SP_NAME, "");
        if (TextUtils.isEmpty((CharSequence)langSp) || !langSp.equals(language)) {
            SharedPreferences.Editor sharedata = sp.edit();
            sharedata.putString(LANGUAGE_SP_KEY, language);
            return sharedata.commit();
        }
        return true;
    }

    public static String getCurrentLanguage(Context context) {
        SharedPreferences sp = context.getApplicationContext().getSharedPreferences(LANGUAGE_SP_NAME, 0);
        return sp.getString(LANGUAGE_SP_KEY, "");
    }
}

