/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexMDM.util.http;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CustomTrustManager
implements X509TrustManager {
    private final X509TrustManager originalX509TrustManager;
    private final KeyStore trustStore;

    public CustomTrustManager(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        this.trustStore = trustStore;
        TrustManagerFactory originalTrustManagerFactory = TrustManagerFactory.getInstance("X509");
        originalTrustManagerFactory.init((KeyStore)null);
        TrustManager[] originalTrustManagers = originalTrustManagerFactory.getTrustManagers();
        this.originalX509TrustManager = (X509TrustManager)originalTrustManagers[0];
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.originalX509TrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException originalException) {
            try {
                X509Certificate[] reorderedChain = this.reorderCertificateChain(chain);
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                CertificateFactory factory = CertificateFactory.getInstance("X509");
                CertPath certPath = factory.generateCertPath(Arrays.asList(reorderedChain));
                PKIXParameters params = new PKIXParameters(this.trustStore);
                params.setRevocationEnabled(false);
                validator.validate(certPath, params);
            }
            catch (Exception ex) {
                throw originalException;
            }
        }
    }

    private X509Certificate[] reorderCertificateChain(X509Certificate[] chain) {
        X509Certificate rootCert;
        X509Certificate[] reorderedChain = new X509Certificate[chain.length];
        List<X509Certificate> certificates = Arrays.asList(chain);
        int position = chain.length - 1;
        reorderedChain[position] = rootCert = this.findRootCert(certificates);
        X509Certificate cert = rootCert;
        while ((cert = this.findSignedCert(cert, certificates)) != null && position > 0) {
            reorderedChain[--position] = cert;
        }
        return reorderedChain;
    }

    private X509Certificate findRootCert(List<X509Certificate> certificates) {
        X509Certificate rootCert = null;
        for (X509Certificate cert : certificates) {
            X509Certificate signer = this.findSigner(cert, certificates);
            if (signer != null && !signer.equals(cert)) continue;
            rootCert = cert;
            break;
        }
        return rootCert;
    }

    private X509Certificate findSignedCert(X509Certificate signingCert, List<X509Certificate> certificates) {
        X509Certificate signed = null;
        for (X509Certificate cert : certificates) {
            Principal signingCertSubjectDN = signingCert.getSubjectDN();
            Principal certIssuerDN = cert.getIssuerDN();
            if (!certIssuerDN.equals(signingCertSubjectDN) || cert.equals(signingCert)) continue;
            signed = cert;
            break;
        }
        return signed;
    }

    private X509Certificate findSigner(X509Certificate signedCert, List<X509Certificate> certificates) {
        X509Certificate signer = null;
        for (X509Certificate cert : certificates) {
            Principal issuerDN;
            Principal certSubjectDN = cert.getSubjectDN();
            if (!certSubjectDN.equals(issuerDN = signedCert.getIssuerDN())) continue;
            signer = cert;
            break;
        }
        return signer;
    }
}

